/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jgamebase.Const;
import jgamebase.db.model.Game;
import jgamebase.db.model.Music;
import jgamebase.gui.ListListModel;
import jgamebase.gui.PathsDialog;
import jgamebase.model.Emulators;
import jgamebase.model.FileExtensions;
import jgamebase.model.Paths;
import jgamebase.model.Plugins;
import jgamebase.plugins.MusicInfo;
import jgamebase.tools.FileTools;
import jgamebase.tools.ListerTools;

public class MusicChooserDialog
extends JDialog {
    private static final long serialVersionUID = -1441411640408078030L;
    private String path;
    private boolean pathAdjusting = false;
    private Const.CloseAction closeAction = Const.CloseAction.CANCEL;
    private final Object[] fileFilters = new Object[]{new FileFilter("All files", "*"), new FileFilter("Only music files", Emulators.getSupportedMusicExtensions().toString())};
    private JComboBox fileFilterComboBox;
    private JList fileSelectionList;
    private JLabel musicAuthor;
    private JLabel musicCopyright;
    private JLabel musicName;
    private JComboBox pathSelectionComboBox;
    private JList pathSelectionList;
    private JButton testButton;

    public MusicChooserDialog() {
        this.init();
        this.setVisible(true);
    }

    public MusicChooserDialog(Game game) {
        String filename = "";
        this.init();
        if (Paths.getMusicPath().exists(new File(game.getMusicFilename()))) {
            this.path = String.valueOf(Paths.getMusicPath().toString()) + game.getMusicFilename();
            filename = Paths.removePath(game.getMusicFilename());
            this.path = this.path.substring(0, this.path.length() - filename.length());
        }
        this.fillPathSelectionList();
        this.fillFileSelectionList();
        List files = ((ListListModel)this.fileSelectionList.getModel()).get();
        int i = 0;
        for (String filenameFromList : files) {
            if (filename.equals(filenameFromList)) {
                this.fileSelectionList.setSelectedIndex(i);
            }
            ++i;
        }
        this.setVisible(true);
    }

    public MusicChooserDialog(Music music) {
        String filename = "";
        this.init();
        if (!Paths.getMusicPath().exists(new File(music.getFilename()))) {
            this.path = String.valueOf(Paths.getMusicPath().toString()) + music.getFilename();
            filename = Paths.removePath(music.getFilename());
            this.path = this.path.substring(0, this.path.length() - filename.length());
        }
        this.fillPathSelectionList();
        this.fillFileSelectionList();
        List files = ((ListListModel)this.fileSelectionList.getModel()).get();
        int i = 0;
        for (String filenameFromList : files) {
            if (filename.equals(filenameFromList)) {
                this.fileSelectionList.setSelectedIndex(i);
            }
            ++i;
        }
        this.setVisible(true);
    }

    private void init() {
        this.initComponents();
        this.pathSelectionComboBox.setModel(new DefaultComboBoxModel<Object>(ListerTools.fileListToStringList(Paths.getMusicPath().getWithDefault()).toArray()));
        this.pathSelectionList.setCellRenderer(new PathSelectionRenderer());
        this.pathSelectionList.setModel(new ListListModel());
        this.path = "";
        if (this.pathSelectionComboBox.getSelectedItem() != null && this.pathSelectionComboBox.getSelectedItem() instanceof String) {
            this.path = (String)this.pathSelectionComboBox.getSelectedItem();
        }
        this.fillPathSelectionList();
        this.fileFilterComboBox.setModel(new DefaultComboBoxModel<Object>(this.fileFilters));
        this.fileSelectionList.setCellRenderer(new FileSelectionRenderer());
        this.fileSelectionList.setModel(new ListListModel());
        this.fillFileSelectionList();
        this.setTestEnabled(false);
    }

    private String getBasePath() {
        if (this.pathSelectionComboBox.getSelectedItem() != null && this.pathSelectionComboBox.getSelectedItem() instanceof String) {
            return Paths.pathEndingWithSeparator((String)this.pathSelectionComboBox.getSelectedItem());
        }
        return "";
    }

    private String getPathWithoutBasePath() {
        if (this.getBasePath().isEmpty() || this.path.isEmpty() || this.getBasePath().length() >= this.path.length()) {
            return "";
        }
        return this.path.substring(this.getBasePath().length());
    }

    /*
     * WARNING - void declaration
     */
    private void fillPathSelectionList() {
        void var5_8;
        ArrayList<PathSelection> paths = new ArrayList<PathSelection>();
        int indentation = 0;
        this.pathAdjusting = true;
        paths.add(new PathSelection(0, this.getBasePath()));
        ++indentation;
        String dirPath = "";
        StringTokenizer st = new StringTokenizer(this.getPathWithoutBasePath(), File.separator);
        while (st.hasMoreTokens()) {
            dirPath = String.valueOf(dirPath) + Paths.pathEndingWithSeparator(st.nextToken());
            if (!new File(String.valueOf(this.getBasePath()) + dirPath).isDirectory()) continue;
            paths.add(new PathSelection(++indentation, String.valueOf(this.getBasePath()) + Paths.pathStartingWithoutSeparator(dirPath)));
        }
        ++indentation;
        List<Object> dirs = new ArrayList();
        try {
            dirs = ListerTools.list_Dirs_Files_Paths(this.path, true, false, true);
        }
        catch (Exception exception) {}
        Collections.sort(dirs, new Comparator(){

            public int compare(Object o1, Object o2) {
                return FileTools.removeExtension(Paths.removePath(((String)o1).toLowerCase())).compareTo(FileTools.removeExtension(Paths.removePath(((String)o2).toLowerCase())));
            }
        });
        for (String string : dirs) {
            paths.add(new PathSelection(indentation, string));
        }
        ((ListListModel)this.pathSelectionList.getModel()).set(paths);
        boolean bl = false;
        while (var5_8 < paths.size()) {
            if (this.path.startsWith(((PathSelection)this.pathSelectionList.getModel().getElementAt((int)var5_8)).getPath())) {
                this.pathSelectionList.setSelectedIndex((int)var5_8);
            }
            ++var5_8;
        }
        this.pathSelectionList.setSelectedValue(this.pathSelectionList.getSelectedValue(), true);
        this.pathAdjusting = false;
    }

    private void fillFileSelectionList() {
        List<Object> files = new ArrayList();
        try {
            files = new FileExtensions(((FileFilter)this.fileFilterComboBox.getSelectedItem()).getExtensions()).getMatching(ListerTools.list_Dirs_Files_Paths(this.path, false, true, false));
        }
        catch (Exception exception) {}
        Collections.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                return FileTools.removeExtension(Paths.removePath(((String)o1).toLowerCase())).compareTo(FileTools.removeExtension(Paths.removePath(((String)o2).toLowerCase())));
            }
        });
        ((ListListModel)this.fileSelectionList.getModel()).set(files);
    }

    private void initComponents() {
        JPanel mainPanel = new JPanel();
        JPanel pathSelectionPanel = new JPanel();
        this.pathSelectionComboBox = new JComboBox();
        JButton jButton2 = new JButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.pathSelectionList = new JList();
        JPanel fileSelectionPanel = new JPanel();
        this.fileFilterComboBox = new JComboBox();
        JButton fileSelectionButton = new JButton();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.fileSelectionList = new JList();
        JLabel jLabel1 = new JLabel();
        JPanel musicPanel = new JPanel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.musicName = new JLabel();
        this.musicAuthor = new JLabel();
        this.musicCopyright = new JLabel();
        JPanel fileActionPanel = new JPanel();
        this.testButton = new JButton();
        JPanel OkCancelPanel = new JPanel();
        JPanel jPanel9 = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.setTitle("Music Selector");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MusicChooserDialog.this.exitFormWindowClosing(evt);
            }
        });
        mainPanel.setLayout(new GridBagLayout());
        pathSelectionPanel.setBorder(BorderFactory.createTitledBorder("1. Select Path"));
        pathSelectionPanel.setLayout(new GridBagLayout());
        this.pathSelectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicChooserDialog.this.pathSelection_ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 3, 2);
        pathSelectionPanel.add((Component)this.pathSelectionComboBox, gridBagConstraints);
        jButton2.setMnemonic('E');
        jButton2.setText("Edit");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicChooserDialog.this.editPaths_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 2, 3, 5);
        pathSelectionPanel.add((Component)jButton2, gridBagConstraints);
        this.pathSelectionList.setSelectionMode(0);
        this.pathSelectionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MusicChooserDialog.this.pathSelected_ValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(this.pathSelectionList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        pathSelectionPanel.add((Component)jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        mainPanel.add((Component)pathSelectionPanel, gridBagConstraints);
        fileSelectionPanel.setBorder(BorderFactory.createTitledBorder("2. Select File"));
        fileSelectionPanel.setLayout(new GridBagLayout());
        this.fileFilterComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicChooserDialog.this.fileFilterSelected_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 2);
        fileSelectionPanel.add((Component)this.fileFilterComboBox, gridBagConstraints);
        fileSelectionButton.setMnemonic('R');
        fileSelectionButton.setText("Refresh");
        fileSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicChooserDialog.this.refreshFiles_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 3, 5);
        fileSelectionPanel.add((Component)fileSelectionButton, gridBagConstraints);
        this.fileSelectionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MusicChooserDialog.this.fileSelected_ValueChanged(evt);
            }
        });
        jScrollPane2.setViewportView(this.fileSelectionList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        fileSelectionPanel.add((Component)jScrollPane2, gridBagConstraints);
        jLabel1.setText("Filter:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 3, 2);
        fileSelectionPanel.add((Component)jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.4;
        mainPanel.add((Component)fileSelectionPanel, gridBagConstraints);
        musicPanel.setBorder(BorderFactory.createTitledBorder("Music-File Info"));
        musicPanel.setLayout(new GridBagLayout());
        jLabel2.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 3, 10);
        musicPanel.add((Component)jLabel2, gridBagConstraints);
        jLabel3.setText("Author");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 3, 10);
        musicPanel.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setText("Copyright");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 10);
        musicPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 3, 5);
        musicPanel.add((Component)this.musicName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        musicPanel.add((Component)this.musicAuthor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        musicPanel.add((Component)this.musicCopyright, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        mainPanel.add((Component)musicPanel, gridBagConstraints);
        this.testButton.setMnemonic('T');
        this.testButton.setText("Test Music");
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicChooserDialog.this.testMusic_ActionPerformed(evt);
            }
        });
        fileActionPanel.add(this.testButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.1;
        mainPanel.add((Component)fileActionPanel, gridBagConstraints);
        this.getContentPane().add((Component)mainPanel, "Center");
        OkCancelPanel.setLayout(new BorderLayout());
        jPanel9.setLayout(new FlowLayout(2));
        okButton.setMnemonic('O');
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicChooserDialog.this.okActionPerformed(evt);
            }
        });
        jPanel9.add(okButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicChooserDialog.this.cancelActionPerformed(evt);
            }
        });
        jPanel9.add(cancelButton);
        OkCancelPanel.add((Component)jPanel9, "South");
        this.getContentPane().add((Component)OkCancelPanel, "South");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void pathSelection_ActionPerformed(ActionEvent evt) {
        if (this.pathSelectionComboBox.getSelectedItem() != null && this.pathSelectionComboBox.getSelectedItem() instanceof String) {
            this.path = (String)this.pathSelectionComboBox.getSelectedItem();
        }
        this.fillPathSelectionList();
    }

    private void fileFilterSelected_ActionPerformed(ActionEvent evt) {
        this.fillFileSelectionList();
    }

    private void okActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.OK;
        this.dispose();
    }

    private void testMusic_ActionPerformed(ActionEvent evt) {
        Music music = new Music();
        music.setName("TEST");
        Const.log.info((Object)"");
        Const.log.info((Object)("Filename:      " + this.getFilename()));
        music.setFilename(this.getFilename());
        music.play();
    }

    protected String getFilename() {
        if (this.fileSelectionList.getSelectedValue() != null && this.fileSelectionList.getSelectedValue() instanceof String) {
            return Paths.pathStartingWithoutSeparator(String.valueOf(Paths.pathEndingWithSeparator(this.getPathWithoutBasePath())) + this.fileSelectionList.getSelectedValue());
        }
        return "";
    }

    private void pathSelected_ValueChanged(ListSelectionEvent evt) {
        if (this.pathAdjusting) {
            return;
        }
        if (this.pathSelectionList.getSelectedValue() != null && this.pathSelectionList.getSelectedValue() instanceof PathSelection) {
            this.path = ((PathSelection)this.pathSelectionList.getSelectedValue()).getPath();
        }
        this.fillPathSelectionList();
        this.fillFileSelectionList();
    }

    private void refreshFiles_ActionPerformed(ActionEvent evt) {
        this.fillFileSelectionList();
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.closeAction = Const.CloseAction.CANCEL;
        this.dispose();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.CANCEL;
        this.dispose();
    }

    private void editPaths_ActionPerformed(ActionEvent evt) {
        new PathsDialog();
        this.pathSelectionComboBox.setModel(new DefaultComboBoxModel<Object>(ListerTools.fileListToStringList(Paths.getMusicPath().getWithDefault()).toArray()));
        this.fillPathSelectionList();
        this.fillFileSelectionList();
    }

    private void fileSelected_ValueChanged(ListSelectionEvent evt) {
        if (this.fileSelectionList.getSelectedValue() != null && this.fileSelectionList.getSelectedValue() instanceof String) {
            String filename = (String)this.fileSelectionList.getSelectedValue();
            String extension = FileTools.getExtension(filename);
            this.musicName.setText("");
            this.musicAuthor.setText("");
            this.musicCopyright.setText("");
            if (Emulators.getSupportedMusicExtensions().contains(extension)) {
                MusicInfo musicInfo;
                Const.log.info((Object)(String.valueOf(filename) + ": STATUS_MUSIC"));
                try {
                    musicInfo = Plugins.getMusicInfoForExtension(extension);
                    musicInfo.load(new File(this.path, filename));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    musicInfo = null;
                }
                if (musicInfo != null) {
                    this.musicName.setText(musicInfo.getName());
                    this.musicAuthor.setText(musicInfo.getAuthor());
                    this.musicCopyright.setText(musicInfo.getCopyright());
                }
                this.setTestEnabled(true);
            } else {
                Const.log.info((Object)(String.valueOf(filename) + ": STATUS_NOTHING"));
                this.setTestEnabled(false);
            }
        }
    }

    private void setTestEnabled(boolean enabled) {
        this.testButton.setEnabled(enabled);
    }

    public Const.CloseAction getCloseAction() {
        return this.closeAction;
    }

    static class FileFilter {
        private final String name;
        private final String extensions;

        public FileFilter(String name, String extensions) {
            this.name = name;
            this.extensions = extensions;
        }

        public String getExtensions() {
            return this.extensions;
        }

        public String toString() {
            return this.name;
        }
    }

    static class FileSelectionRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -7853030169895254991L;

        public FileSelectionRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected || cellHasFocus) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            if (value instanceof String) {
                this.setIcon(Const.ICON_GS_FILE);
                String filename = (String)value;
                String extension = FileTools.getExtension(filename);
                if (Emulators.getSupportedMusicExtensions().contains(extension)) {
                    this.setIcon(Const.ICON_GS_MUSIC);
                }
                if (Emulators.getSupportedGameExtensions().contains(extension)) {
                    this.setIcon(Const.ICON_GS_GAME);
                }
                if (Plugins.existsDiskInfoForExtension(extension)) {
                    this.setIcon(Const.ICON_GS_IMAGE);
                }
                if (Plugins.existsExtractorForExtension(extension)) {
                    this.setIcon(Const.ICON_GS_COMPRESSED);
                }
                if ((filename = Paths.pathEndingWithoutSeparator(filename)).contains(File.separator)) {
                    filename = filename.substring(filename.lastIndexOf(File.separator), filename.length());
                }
                filename = Paths.pathStartingWithoutSeparator(filename);
                this.setText(filename);
            }
            return this;
        }
    }

    static class PathSelection {
        private final int indentation;
        private final String path;

        public PathSelection(int indentation, String path) {
            this.indentation = indentation;
            this.path = Paths.pathEndingWithSeparator(path);
        }

        public int getIndentation() {
            return this.indentation;
        }

        public String getPath() {
            return this.path;
        }
    }

    static class PathSelectionRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 321736731032204969L;

        public PathSelectionRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected || cellHasFocus) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            if (value instanceof PathSelection) {
                if (isSelected || cellHasFocus) {
                    this.setIcon(Const.ICON_GS_FOLDER_OPEN);
                } else {
                    this.setIcon(Const.ICON_GS_FOLDER);
                }
                PathSelection selection = (PathSelection)value;
                String pathName = selection.getPath();
                int indentation = selection.getIndentation();
                pathName = pathName.substring(0, pathName.length() - 1);
                if (pathName.contains(File.separator)) {
                    pathName = pathName.substring(pathName.lastIndexOf(File.separator), pathName.length());
                }
                pathName = Paths.pathStartingWithoutSeparator(pathName);
                this.setText(pathName);
                this.setBorder(new EmptyBorder(new Insets(0, indentation * 10, 0, 0)));
            }
            return this;
        }
    }
}

